//
// Description : Array and textureless GLSL 2D simplex noise function.
//      Author : Ian McEwan, Ashima Arts.
//  Maintainer : stegu
//     Lastmod : 20110822 (ijm)
//     License : Copyright (C) 2011 Ashima Arts. All rights reserved.
//               Distributed under the MIT License. See LICENSE file.
//               https://github.com/ashima/webgl-noise
//               https://github.com/stegu/webgl-noise
// 

#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_MIRRORED_REPEAT | CLK_FILTER_LINEAR;

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}
vec3 mod3(vec3 x) {
  return x - floor(x * (1.0f / 290.0f)) * 290.0f;
}
vec2 mod2(vec2 x) {
  return x - floor(x * (1.0f / 290.0f)) * 290.0f;
}
vec3 Align(vec3 x) {
  return mod3(((x*34.0f)+1.0f)*x);
}
float snoise(vec2 v) {   
    vec2 i  = floor(v + dot(v, (vec2)(0.366025403784439f)) );
    vec2 x0 = v -   i + dot(i, (vec2)(0.211324865405187f));
    vec2 i1;
    i1 = (x0.x > x0.y) ? (vec2)(1.0f, 0.0f) : (vec2)(0.0f, 1.0f);

    vec4 x12 = (vec4)(x0.x,x0.y,x0.x,x0.y) + (vec4)(0.211324865405187f,0.211324865405187f,-0.577350269189626f,-0.577350269189626f);
    x12.xy -= i1;
    
    i = mod2(i); 
    vec3 p = Align( Align( i.y + (vec3)(0.0f, i1.y, 1.0f )) + i.x + (vec3)(0.0f, i1.x, 1.0f ));

    vec3 m = max((vec3)(0.5f) - (vec3)(dot(x0,x0), dot(x12.xy,x12.xy), dot(x12.zw,x12.zw)), 0.0f);
    m = m*m ;
    m = m*m ;

    float3 iptr = (float3)(0.0f);
    vec3 x = 2.0f * fract(p * (vec3)(0.024390243902439f),&iptr) - 1.0f;    
    vec3 h = fabs(x) - 0.5f;
    vec3 ox = floor(x + 0.5f);
    vec3 a0 = x - ox;
    m *= 1.79284291400159f - 0.85373472095314f * ( a0*a0 + h*h );
    vec3 g;
    g.x  = a0.x  * x0.x  + h.x  * x0.y;
    g.yz = a0.yz * x12.xz + h.yz * x12.yw;
    return 130.0f * dot(m, g);
}

float rand(vec2 co)
{
    float itpr = (float)(0.0f);
    return fract(sin(dot(co.xy,(vec2)(12.9898f,78.233f))) * 43758.5453f,&itpr);
}

__kernel void MAIN(
      __read_only image2d_t input,    
      __write_only image2d_t dest_data,
      __global FilterParam* param,
	  int alpha) 
{
    
    int W = get_global_size(0);
	int H = get_global_size(1);
    float2 ouputResolution = (float2)(W,H);  
    int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));

    vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
    vec2 resolution = ouputResolution;
	vec2 tc = ((float2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/ouputResolution.xy;
    vec2 uv = (float2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
    float4 orig = read_imagef(input, sampler, uv);        
    float fragX = (float)(get_global_id(0) - get_global_offset(0));
    float fragY = (float)(get_global_id(1) - get_global_offset(1));
    vec2 frag = (vec2)(fragX,fragY) + (vec2)(0.5f);	
    vec2 uv2 = tc;
    float time = param->cur_time * 2.0f;   
   
  
    float noise = max(0.0f, snoise((vec2)(time, (1.0f-uv2.y) * 0.3f)) - 0.3f) * (1.0f / 0.7f);    

    noise = noise + (snoise((vec2)(time*10.0f,(1.0f-uv2.y) * 2.4f)) - 0.5f) * 0.15f;    

    float xpos = uv2.x - noise * noise * 0.25f;
	float onePixel = 1.0f / (float)(W);
	xpos = step(onePixel,xpos)*xpos*2.0f - xpos + onePixel;
	
	vec4 fragColor = INPUTSRC(input,param,(vec2)(xpos, uv2.y));    
	//vec4 fragColor = INPUTSRC(input,param,(vec2)(0.0f, uv2.y));    

    fragColor.xyz = mix(fragColor.xyz, (vec3)(rand((vec2)(uv2.y * time))), noise * 0.3f).xyz;    
  
    if (floor(fmod(frag.y * 0.25f, 2.0f)) == 0.0f)
    {
        fragColor.xyz *= 1.0f - (0.15f * noise);
    }  

    fragColor.y = mix(fragColor.x, INPUTSRC(input,param,(vec2)(xpos + noise * 0.05f, uv2.y)).y, 0.25f);
    fragColor.z = mix(fragColor.x, INPUTSRC(input,param,(vec2)(xpos - noise * 0.05f, uv2.y)).z, 0.25f);
	fragColor.w = orig.w;
 
    vec4 retColor =  mix( fragColor, orig, 1.0f - (float)(alpha)/100.0f ); 
    write_imagef(dest_data,gl_FragCoord,retColor);
}



